/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.mail;

import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.logging.PluginLogger;
import net.impactdev.impactor.api.mail.MailMessage;
import net.impactdev.impactor.api.mail.MailService;
import net.impactdev.impactor.api.providers.FactoryProvider;
import net.impactdev.impactor.core.mail.ImpactorMailMessage;
import net.impactdev.impactor.core.mail.registration.ImpactorSuggestMailServiceEvent;
import net.impactdev.impactor.core.mail.registration.MailServiceRegistrationProvider;
import net.impactdev.impactor.core.modules.ImpactorModule;

public final class MailModule
implements ImpactorModule {
    @Override
    public void factories(FactoryProvider provider) {
        provider.register(MailMessage.Factory.class, new ImpactorMailMessage.MaillMessageFactory());
    }

    @Override
    public void init(Impactor impactor, PluginLogger logger) throws Exception {
        MailServiceRegistrationProvider registration = new MailServiceRegistrationProvider();
        impactor.events().post((Object)new ImpactorSuggestMailServiceEvent(registration));
        String service = registration.suggestion().metadata().name().orElse(registration.suggestion().metadata().id());
        logger.info("Registering mail service (Provider: " + service + ")");
        impactor.services().register(MailService.class, registration.suggestion().supplier().get());
    }
}

